
# Globals
set drvlist [list]

proc uboot_drc {os_handle} {
    puts "\#--------------------------------------"
    puts "\# uboot BSP DRC...!"
    puts "\#--------------------------------------"
}

proc generate {os_handle} {
    variable drvlist
    puts "\#--------------------------------------"
    puts "\# uboot BSP generate..."
    puts "\#--------------------------------------"

    # otevreni nastavovaciho souboru
    set config_file_name "xparameters.h"
    set config_file [open $config_file_name w]

    # vypsani havlicky
    xprint_header $config_file
    puts $config_file ""


    set proc_handle [xget_libgen_proc_handle]
# ************************************************************************************************************
# print system clock
    set sys_clock [xget_sw_parameter_value $proc_handle "CORE_CLOCK_FREQ_HZ"]
    puts $config_file "/* System Clock Frequency */"
    puts $config_file "#define XILINX_CLOCK_FREQ  $sys_clock"
    puts $config_file ""
# ************************************************************************************************************
# zjisteni informaci o interrupt controleru
    set intc [xget_sw_parameter_value $os_handle "intc"]
    if {[string match "" $intc] || [string match -nocase "none" $intc]} {
            puts $config_file "/* Interrupt controller not defined */"
    } else {
	    puts $config_file "/* Interrupt controller is $intc */"
# zjisteni vsech periferii, ktere maji intc jako ovladac - zatim predpokladam, ze je takova periferie jen jedna
	    set per_num [xget_handle $proc_handle "DRIVER" "intc"]
	    set per_mhs_param [xget_sw_iplist_for_driver $per_num]
# vybrani adresy interrupt controlleru
	    set baseaddr [xget_sw_parameter_handle $per_mhs_param "C_BASEADDR"]
	    set baseaddr_value [xget_value $baseaddr "VALUE"]
            set baseaddr_value [format "0x%08x" $baseaddr_value]
	    puts $config_file "#define XILINX_INTC_BASEADDR  $baseaddr_value"
# vybrani poctu vstupu interruptu a zapamatovani intr_value
	    set number_intr [xget_sw_parameter_handle $per_mhs_param "C_NUM_INTR_INPUTS"]
	    set intr_value [xget_value $number_intr "VALUE"]
	    puts $config_file "#define XILINX_INTC_NUM_INTR_INPUTS  $intr_value"
# interrupty se pocitaji od 0li - takze potrebuji mit o jedna mensi pocty
	    set intr_value [expr $intr_value - 1]
#zjisteni portu intr - jake jsou pripojene interrupty a vylistovani jich
	    set intc_handle [xget_sw_ipinst_handle_from_processor $proc_handle $intc]
    	    set port_list [xget_port_by_subtype $intc_handle "*"]
    	    foreach port $port_list {
    	     	    set name [xget_value $port "NAME"]
    	     	    if {[string match -nocase $name "intr"]} {
		       	    set intr_irq [xget_value $port "VALUE"]
		       	    puts $config_file "/* pripojene interrupty $name=$intr_irq */"
    	     	    }
    	    }
     }
    puts $config_file ""
# ************************************************************************************************************
# zjisteni informaci o timeru
    set timer [xget_sw_parameter_value $os_handle "timer"]
    if {[string match "" $timer] || [string match -nocase "none" $timer]} {
            puts $config_file "/* Timer not defined */"
    } else {
	    set timer_handle [xget_sw_ipinst_handle_from_processor $proc_handle $timer]
	    set timer_start [xget_sw_parameter_value $timer_handle "C_BASEADDR"]
	    set timer_start [format "0x%08x" $timer_start]
	    puts $config_file "/* Timer pheriphery is $timer */"
	    puts $config_file "#define XILINX_TIMER_BASEADDR\t$timer_start"
	    
	    if {![string match "" $intc] && ![string match -nocase "none" $intc]} {
		    set port_list [xget_port_by_subtype $timer_handle "*"]
		    foreach port $port_list {
		     	    set name [xget_value $port "NAME"]
		     	    if {[string match -nocase $name "interrupt"]} {
		  	     	    set value [xget_value $port "VALUE"]
	   	 		    # spocitam kolikata polozka je interrupt pro timer - max delka
			    	    set delka $intr_value
				    # cyklus pres vsechny pripojene draty
				    foreach cislo $intr_irq {
				    	    # mimo konkatenace - tu preskoc
				    	    if {![string match $cislo "&"]} {
					       	    # pokud jsi nasel stejne cislo dratu tak skonci
					     	    if {[string match -nocase $cislo $value]} {
					     	        puts $config_file "#define XILINX_TIMER_IRQ  $delka"
					     	    }
					     	    # odcitej do nuly
					     	    set delka [expr $delka - 1]
			 	    	    }
				    }
		     	    }
		    }
	     }


    }
    puts $config_file ""
# ************************************************************************************************************
# zjisteni informaci o uartu - predpokladam, ze je to uartlite
    set uart [xget_sw_parameter_value $os_handle "stdin_out"]
    if {[string match "" $uart] || [string match -nocase "none" $uart]} {
            puts $config_file "/* Uartlite not defined */"
            error "ERROR Uartlite not specified. Please specific console"
    } else {
	    set uart_handle [xget_sw_ipinst_handle_from_processor $proc_handle $uart]
	    set uart_baseaddr [xget_sw_parameter_value $uart_handle "C_BASEADDR"]
	    set uart_baseaddr [format "0x%08x" $uart_baseaddr]
	    set uart_baudrate [xget_sw_parameter_value $uart_handle "C_BAUDRATE"]
	    puts $config_file "/* Uart pheriphery is $uart */"
	    puts $config_file "#define XILINX_UART_BASEADDR  $uart_baseaddr"
	    puts $config_file "#define XILINX_UART_BAUDRATE  $uart_baudrate"
    }
    puts $config_file ""
# ************************************************************************************************************
# Konfigurace pro gpio
    set gpio [xget_sw_parameter_value $os_handle "gpio"]
    if {[string match "" $gpio] || [string match "none" $gpio]} {
      	 puts $config_file "/* Gpio doesn't exist */"
    } else {
         set base_param_name [format "C_BASEADDR" $gpio]
	 set gpio_handle [xget_sw_ipinst_handle_from_processor $proc_handle $gpio]
	 set gpio_start [xget_sw_parameter_value $gpio_handle $base_param_name]
	 set gpio_start [format "0x%08x" $gpio_start]
	 puts $config_file "/* GPIO is $gpio*/"
	 puts $config_file "#define XILINX_GPIO_BASEADDR  $gpio_start"
    }
    puts $config_file ""
# ************************************************************************************************************
# print flash memory
    set flash_mem [xget_sw_parameter_value $os_handle "flash"]
     if {[string match "" $flash_mem] || [string match "none" $flash_mem]} {
      	 puts $config_file "/* FLASH doesn't exist $flash_mem */"
     } else {
	set flash_mem_handle [xget_sw_ipinst_handle_from_processor $proc_handle $flash_mem]
        set flash_mem_bank [xget_sw_parameter_value $os_handle "flash_mem_bank"]
	set base_param_name [format "C_MEM%i_BASEADDR" $flash_mem_bank]
	set high_param_name [format "C_MEM%i_HIGHADDR" $flash_mem_bank]
	set flash_start [xget_sw_parameter_value $flash_mem_handle $base_param_name]
	set flash_end [xget_sw_parameter_value $flash_mem_handle $high_param_name]
	set flash_size [expr $flash_end - $flash_start + 1]
	set flashm_start [format "0x%08x" $flash_start]
	set flash_size [format "0x%08x" $flash_size]
	puts $config_file "/* Flash Memory is $flash_mem */"
	puts $config_file "#define XILINX_FLASH_START  $flash_start"
	puts $config_file "#define XILINX_FLASH_SIZE  $flash_size"
    }
    puts $config_file ""
# ************************************************************************************************************
# print system memory
    set main_mem [xget_sw_parameter_value $os_handle "main_memory"]
    if {[string match "" $main_mem] || [string match "none" $main_mem]} {
         error "ERROR main_memory not specified. Please specific main_memory"
    } else {
	    set main_mem_bank [xget_sw_parameter_value $os_handle "main_memory_bank"]
	    set main_mem_handle [xget_sw_ipinst_handle_from_processor $proc_handle $main_mem]
	    if {[string compare -nocase $main_mem_handle ""] != 0} {
	        set base_param_name [format "C_MEM%i_BASEADDR" $main_mem_bank]
	        set high_param_name [format "C_MEM%i_HIGHADDR" $main_mem_bank]
		set eram_base [xget_sw_parameter_value $main_mem_handle $base_param_name]
		set eram_end [xget_sw_parameter_value $main_mem_handle $high_param_name]
		set eram_size [expr $eram_end - $eram_base + 1]
		set eram_base [format "0x%08x" $eram_base]
		set eram_size [format "0x%08x" $eram_size]
		set eram_high [expr $eram_base + $eram_size]
		set eram_high [format "0x%08x" $eram_high]
		puts $config_file "/* Main Memory is $main_mem */"
		puts $config_file "#define XILINX_RAM_START  $eram_base"
		puts $config_file "#define XILINX_RAM_SIZE  $eram_size"
	    }
    }
    puts $config_file ""
# ************************************************************************************************************
# sysace
     set sysace [xget_sw_parameter_value $os_handle "sysace"]
     if {[string match "" $sysace] || [string match "none" $sysace]} {
      	 puts $config_file "/* sysace doesn't exist */"
     } else {
	    puts $config_file "/* sysace controller is $sysace */"
	    set drv [xget_handle $proc_handle "DRIVER" "sysace"]
	    # device_id is fixed on value
	    set periphs [xget_sw_iplist_for_driver $drv]
	    foreach periph $periphs {
	    	    #ziskavani sw_parametru
	    	    set args [xget_sw_parameter_handle $periph "*"]
	    	    foreach arg $args {
			set arg_name [xget_value $arg "NAME"]
			set arg_name [string map -nocase {C_ ""} $arg_name]
#		        puts $config_file "$arg_name $arg_value"
			#vypsani parametru s vyuzitim case
			case $arg_name in {
			    {"BASEADDR" "HIGHADDR" "MEM_WIDTH"} {
			    		set arg_value [xget_value $arg "VALUE"]
					puts $config_file "#define XILINX_SYSACE_${arg_name}  $arg_value"
					}
			    default	{}
			}
	    	    }
	    }
    }
    puts $config_file ""
# ************************************************************************************************************
# ethernet
     set ethernet [xget_sw_parameter_value $os_handle "ethernet"]
     if {[string match "" $ethernet] || [string match "none" $ethernet]} {
      	 puts $config_file "/* ethernet doesn't exist */"
     } else {
	    puts $config_file "/* Ethernet controller is $ethernet */"
	    set drv [xget_handle $proc_handle "DRIVER" "emac"]
	    set pocet [llength $drv]
	    puts $config_file "#define XPAR_XEMAC_NUM_INSTANCES  $pocet"
	    # device_id is fixed on value
	    puts $config_file "#define XPAR_OPB_ETHERNET_0_DEVICE_ID  [expr $pocet - 1]"
	    set periphs [xget_sw_iplist_for_driver $drv]
	    foreach periph $periphs {
	    	    #ziskavani sw_parametru
	    	    set args [xget_sw_parameter_handle $periph "*"]
	    	    foreach arg $args {
			set arg_name [xget_value $arg "NAME"]
			set arg_name [string map -nocase {C_ ""} $arg_name]
#		        puts $config_file "$arg_name $arg_value"
			#vypsani parametru s vyuzitim case
			case $arg_name in {
			    {"BASEADDR" "HIGHADDR" "ERR_COUNT_EXIST" "DMA_PRESENT" "MII_EXIST"} {
			    		set arg_value [xget_value $arg "VALUE"]
					puts $config_file "#define XPAR_OPB_ETHERNET_0_${arg_name}  $arg_value"
					}
			    default	{}
			}
	    	    }
	    }
    }
    puts $config_file ""







# ziskani vsech moznych parametru
#
#    set intc [xget_sw_parameter_value $os_handle "intc"]
#    puts $config_file "intc $intc"
#
#
#    set proc_handle [xget_libgen_proc_handle]
#    set drvlist [xget_handle $proc_handle "DRIVER" "*"]
#
#    foreach drv $drvlist {
#    	    #ziskavam jmeno driveru
#    	    set drv_name [xget_value $drv "NAME"]
#
#  	    if {[string match -nocase $drv_name "sysace" ] || [string match -nocase $drv_name "intc" ]} {
#		    puts $config_file "drv_name: $drv_name"
#		    set periphs [xget_sw_iplist_for_driver $drv]
#		    foreach periph $periphs {
#		    	    #ziskavani sw_parametru
#		    	    set args [xget_sw_parameter_handle $periph "*"]
#		    	    foreach arg $args {
#				set arg_name [xget_value $arg "NAME"]
#				set arg_value [xget_value $arg "VALUE"]
#				puts $config_file "$arg_name $arg_value"
#
#
#		    	    }
#		    	    puts $config_file ""
#
#
#		    	    #ziskavani irq listu
#		    	    set periph_name [string toupper [xget_value $periph "VALUE"]]
#		    	    if {![string match -nocase *_intc $periph_name]} {
#			    	    set port_list [xget_port_by_subtype $periph "*"]
#			    	    puts $config_file "$port_list"
#			    	    foreach port $port_list {
#			    	     	    set name [xget_value $port "NAME"]
#			    	     	    set value [xget_value $port "VALUE"]
#			    	     	    puts $config_file "$name $value"
#			    	     	    #pro timer
#			    	     	    if {[string match -nocase $name "interrupt"]} {
#				    	     	    puts $config_file "$name $value"
#						    set timer_int $value
#			    	     	    }
#			    	     	    #pro sysace
#			    	     	    if {[string match -nocase $name "SysACE_IRQ"]} {
#				    	     	    puts $config_file "$name $value"
#						    set timer_int $value
#			    	     	    }
#			    	    }
#		    	    } else {
#			    	    set port_list [xget_port_by_subtype $periph "*"]
#			    	    puts $config_file "$port_list"
#			    	    foreach port $port_list {
#			    	     	    set name [xget_value $port "NAME"]
#			    	     	    set value [xget_value $port "VALUE"]
#			    	     	    if {[string match -nocase $name "intr"]} {
#				    	     	    puts $config_file "$name $value - $timer_int"
#
#				    	     	    #musime provest srovnani aby vypadlo cislo
#				    	     	    # delka je C_NUM_INTR_INPUTS -1 - abychom zacinaly od nuly
#				    	     	    set delka "10"
#						    foreach cislo $value {
#						    	    if {![string match $cislo "&"]} {
#							     	    puts $config_file "$delka"
#							     	    if {[string match -nocase $cislo $timer_int]} {
#							     	        puts $config_file "nasel jsem ze se rovna $delka"
#							     	    }
#							     	    set delka [expr $delka - 1]
#	     	    		                            }
#						    }
#
#
#			    	     	    }
#			    	    }
#
#
#
#		    	    }
#
#
#
#		    	    puts $config_file ""
#		    }
#            }
#     }

    # close the file...
    close $config_file
#*************************************************************************************************************
    # otevreni souboru pro config.mk
    set config_file_name "config.mk"
    set config_file [open $config_file_name w]

    # vypsani hlavicky
    xprint_header2 $config_file
    puts $config_file ""

    # zjisteni uboot_position v pameti
    set text_base [xget_sw_parameter_value $os_handle "uboot_position"]
    set text_base [format "0x%08x" $text_base]
    if {$eram_base < $text_base && $eram_high > $text_base} {
	    puts $config_file "# TEXT BASE "
	    puts $config_file "TEXT_BASE = $text_base"
	    puts $config_file ""
# musi se dodelat parametry
	    puts $config_file "PLATFORM_CPPFLAGS += -mno-xl-soft-mul"
	    puts $config_file "PLATFORM_CPPFLAGS += -mno-xl-soft-div"
	    puts $config_file "PLATFORM_CPPFLAGS += -mxl-barrel-shift"
	    puts $config_file ""

    } else {
      	    error "ERROR u-boot position is out of range $eram_base - $eram_high"
    }
    # zavreni souboru
    close $config_file
#*************************************************************************************************************
}

##################################################
# procedure post_generate
# This generates the drivers directory for uboot
# and runs the ltypes script
##################################################

proc post_generate {lib_handle} {
    set pwd [pwd]
    set name [xget_value $lib_handle "PARAMETER" name]
    if {$name != ""} {
	    set uboot_dir "uboot/board/xilinx/$name"
	    exec bash -c "mkdir -p $uboot_dir"
	    exec bash -c "cp ../../include/xparameters.h $uboot_dir/xparameters-edk.h"
	    exec bash -c "cp ../../../system.mhs $uboot_dir"
	    exec bash -c "cp ../../../system.mss $uboot_dir"
	    exec bash -c "mv xparameters.h $uboot_dir"
	    exec bash -c "mv config.mk $uboot_dir"
    }
}


# procedura na generovani hlavicky
proc xprint_header {config_file} {

    puts $config_file "/*********************************************************************"
    header $config_file
    puts $config_file "**********************************************************************/"
}

proc xprint_header2 {config_file} {

    puts $config_file "\#*********************************************************************"
    header $config_file
    puts $config_file "\#**********************************************************************"
}

proc header {config_file} {
    puts $config_file "\# "
    puts $config_file "\# CAUTION: This file is automatically generated by libgen."
    puts $config_file "\# Version: [xget_swverandbld] "
    puts $config_file "\# Description: uboot Configuration File"
    puts $config_file "\# Michal Simek - www.monstr.eu"
    puts $config_file "\# "
}
